/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.AbstractRenderElement;
import net.createmod.catnip.gui.element.BoxElement;
import net.createmod.catnip.gui.widget.AbstractSimiWidget;
import net.createmod.catnip.gui.widget.BoxWidget;
import net.createmod.catnip.lang.ClientFontHelper;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.catnip.layout.LayoutHelper;
import net.createmod.catnip.layout.PaginationState;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.enums.PonderGuiTextures;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.PonderTag;
import net.createmod.ponder.foundation.ui.AbstractPonderScreen;
import net.createmod.ponder.foundation.ui.PonderButton;
import net.createmod.ponder.foundation.ui.PonderTagScreen;
import net.createmod.ponder.foundation.ui.PonderUI;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_768;

public class PonderTagIndexScreen
extends AbstractPonderScreen {
    protected List<ModTagsEntry> currentModTagEntries = new LinkedList<ModTagsEntry>();
    protected List<Map.Entry<String, List<PonderTag>>> sortedModTags = List.of();
    protected PaginationState paginationState = new PaginationState();
    @Nullable
    protected PonderButton pageNext;
    @Nullable
    protected PonderButton pagePrev;
    @Nullable
    private PonderTag hoveredItem = null;

    @Override
    protected void method_25426() {
        super.method_25426();
        Map<String, List<PonderTag>> tagsByModID = PonderIndex.getTagAccess().getListedTags().stream().collect(Collectors.groupingBy(tag -> tag.getId().method_12836()));
        this.sortedModTags = new TreeMap<String, List<PonderTag>>(tagsByModID).entrySet().stream().toList();
        int modCount = this.sortedModTags.size();
        int maxModsOnScreen = (this.field_22790 - 140 - 40) / 58;
        this.paginationState = new PaginationState(modCount > 1 && modCount > maxModsOnScreen, maxModsOnScreen, modCount);
        this.setupModTagEntries();
        if (!this.paginationState.usesPagination()) {
            return;
        }
        int xOffset = (int)((double)this.field_22789 * 0.5);
        this.pagePrev = (PonderButton)((AbstractSimiWidget)((AbstractSimiWidget)new PonderButton(xOffset - 120, this.field_22790 - 32).showing(PonderGuiTextures.ICON_PONDER_LEFT)).withCallback(() -> {
            this.paginationState.previousPage();
            this.updateAfterPaginationChange();
        })).setActive(false);
        this.method_37063(this.pagePrev);
        this.pagePrev.updateGradientFromState();
        this.pageNext = (PonderButton)((AbstractSimiWidget)((AbstractSimiWidget)new PonderButton(xOffset + 100, this.field_22790 - 32).showing(PonderGuiTextures.ICON_PONDER_RIGHT)).withCallback(() -> {
            this.paginationState.nextPage();
            this.updateAfterPaginationChange();
        })).setActive(true);
        this.method_37063(this.pageNext);
    }

    protected void setupModTagEntries() {
        this.removeWidgets(this.method_25396().stream().filter(widget -> {
            if (!(widget instanceof PonderButton)) {
                return false;
            }
            PonderButton ponderButton = (PonderButton)widget;
            return ponderButton.tag != null;
        }).toList());
        this.currentModTagEntries.clear();
        AtomicInteger yOffset = new AtomicInteger(140);
        int xOffset = (int)((double)this.field_22789 * 0.5);
        this.paginationState.iterateForCurrentPage((iPage, iOverall) -> {
            Map.Entry<String, List<PonderTag>> entry = this.sortedModTags.get((int)iOverall);
            String modName = CatnipServices.PLATFORM.getModDisplayName(entry.getKey());
            List<PonderTag> tags = entry.getValue();
            LayoutHelper layout = LayoutHelper.centeredHorizontal(tags.size(), 1, 28, 28, 8);
            class_768 layoutArea = layout.getArea();
            for (PonderTag tag : tags) {
                PonderButton button = (PonderButton)((AbstractSimiWidget)new PonderButton(xOffset + layout.getX() + 4, yOffset.get() + layout.getY() + 18).showingTag(tag)).withCallback((mouseX, mouseY) -> {
                    this.centerScalingOn((int)mouseX, (int)mouseY);
                    ScreenOpener.transitionTo(new PonderTagScreen(tag));
                });
                this.method_37063(button);
                layout.next();
            }
            this.currentModTagEntries.add(new ModTagsEntry(modName, tags.size(), layoutArea, yOffset.get()));
            yOffset.addAndGet(68);
        });
        for (int i = 0; i < this.paginationState.getElementsPerPage() && this.paginationState.getStartIndex() + i < this.sortedModTags.size(); ++i) {
        }
    }

    protected void updateAfterPaginationChange() {
        this.setupModTagEntries();
        ((PonderButton)this.pagePrev.setActive(this.paginationState.hasPreviousPage())).animateGradientFromState();
        ((PonderButton)this.pageNext.setActive(this.paginationState.hasNextPage())).animateGradientFromState();
    }

    @Override
    protected void initBackTrackIcon(BoxWidget backTrack) {
        backTrack.showing(PonderGuiTextures.ICON_PONDER_IDENTIFY);
    }

    @Override
    public void method_25393() {
        super.method_25393();
        ++PonderUI.ponderTicks;
        this.hoveredItem = null;
        class_1041 w = this.field_22787.method_22683();
        double mouseX = this.field_22787.field_1729.method_1603() * (double)w.method_4486() / (double)w.method_4480();
        double mouseY = this.field_22787.field_1729.method_1604() * (double)w.method_4502() / (double)w.method_4507();
        for (class_364 child : this.method_25396()) {
            PonderButton button;
            if (child == this.backTrack || !(child instanceof PonderButton) || !(button = (PonderButton)child).method_25405(mouseX, mouseY)) continue;
            this.hoveredItem = button.getTag();
        }
    }

    @Override
    protected void renderWindow(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindow(graphics, mouseX, mouseY, partialTicks);
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_22904((double)this.field_22789 / 2.0, 30.0, 0.0);
        poseStack.method_22903();
        poseStack.method_46416(-120.0f, 0.0f, 0.0f);
        String title = Ponder.lang().translate("ui.welcome", new Object[0]).string();
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at(0.0f, 0.0f, 0.0f).withBounds(30, 30).render(graphics);
        PonderGuiTextures.LOGO.render(graphics, -1, -1);
        poseStack.method_46416(34.0f, -3.0f, 0.0f);
        int streakHeight = 36;
        UIRenderHelper.streak(graphics, 0.0f, 0, streakHeight / 2, streakHeight, 280);
        poseStack.method_22905(2.0f, 2.0f, 2.0f);
        graphics.method_51433(this.field_22793, title, 3, 5, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB(), false);
        poseStack.method_22909();
        poseStack.method_46416(0.0f, 50.0f, 0.0f);
        poseStack.method_22903();
        int maxWidth = (int)((float)this.field_22789 * 0.5f);
        String desc = Ponder.lang().translate("ui.index_description", new Object[0]).string();
        int descWidth = this.field_22793.method_1727(desc);
        if (descWidth + 2 < maxWidth) {
            maxWidth = descWidth + 2;
        }
        int descHeight = this.field_22793.method_1713(desc, maxWidth);
        poseStack.method_46416((float)(-maxWidth) / 2.0f, 0.0f, 0.0f);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at(-3.0f, -3.0f, 0.0f).withBounds(maxWidth + 6, descHeight + 5).render(graphics);
        ClientFontHelper.drawSplitString(poseStack, this.field_22793, desc, 0, 0, maxWidth, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB());
        poseStack.method_22909();
        poseStack.method_46416(0.0f, -80.0f, 0.0f);
        for (ModTagsEntry entry : this.currentModTagEntries) {
            poseStack.method_22903();
            this.renderTagsEntry(graphics, entry);
            poseStack.method_22909();
        }
        poseStack.method_22909();
    }

    protected void renderTagsEntry(class_332 graphics, ModTagsEntry entry) {
        class_4587 poseStack = graphics.method_51448();
        int layoutWidth = entry.layoutArea().method_3319();
        int layoutHeight = entry.layoutArea().method_3320();
        poseStack.method_46416(0.0f, (float)entry.yPos(), 0.0f);
        String categories = Ponder.lang().translate("ui.categories", entry.modName()).string();
        int stringWidth = this.field_22793.method_1727(categories);
        poseStack.method_22903();
        poseStack.method_46416((float)(-stringWidth) / 2.0f, -20.0f, 0.0f);
        ((AbstractRenderElement)((BoxElement)new BoxElement().withBackground(PonderUI.BACKGROUND_FLAT)).gradientBorder(PonderUI.COLOR_IDLE)).at(-3.0f, -1.0f, 0.0f).withBounds(stringWidth + 6, 10).render(graphics);
        graphics.method_51433(this.field_22793, categories, 0, 0, ((Color)UIRenderHelper.COLOR_TEXT.getFirst()).getRGB(), false);
        poseStack.method_22909();
        int extraLength = class_3532.method_15340((int)entry.tagCount, (int)2, (int)8);
        UIRenderHelper.streak(graphics, 0.0f, 0, layoutHeight / 2, layoutHeight + 6, layoutWidth / 2 + extraLength * 15);
        UIRenderHelper.streak(graphics, 180.0f, 0, layoutHeight / 2, layoutHeight + 6, layoutWidth / 2 + extraLength * 15);
    }

    @Override
    protected void renderWindowForeground(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.disableDepthTest();
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 200.0f);
        if (this.hoveredItem != null) {
            List<class_2561> list = FontHelper.cutStringTextComponent(this.hoveredItem.getDescription(), FontHelper.Palette.ALL_GRAY);
            list.add(0, (class_2561)class_2561.method_43470((String)this.hoveredItem.getTitle()));
            graphics.method_51434(this.field_22793, list, mouseX, mouseY);
        }
        poseStack.method_22909();
        RenderSystem.enableDepthTest();
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    public void method_25432() {
        super.method_25432();
        this.hoveredItem = null;
    }

    public record ModTagsEntry(String modName, int tagCount, class_768 layoutArea, int yPos) {
    }
}

